CREATE TABLE GLB_FUSO_HORARIO (
    CD_FUSO_HORARIO INT IDENTITY(1,1) NOT NULL,
    DS_FUSO_HORARIO VARCHAR(50) NOT NULL,
    DIFER_MINUTOS INT NOT NULL,
    CONSTRAINT PK_GLB_FUSO_HORARIO PRIMARY KEY (CD_FUSO_HORARIO)
)
GO
CREATE TABLE PRC_FILIAL_GLB_FUSO_HORARIO (
    CD_CTR INT IDENTITY(1,1) NOT NULL,
    CD_EMP INT NOT NULL,
    CD_FILIAL INT NOT NULL,
    CD_FUSO_HORARIO INT NOT NULL,
    CONSTRAINT PK_PRC_FILIAL_GLB_FUSO_HORARIO PRIMARY KEY (CD_CTR)
)
GO
ALTER TABLE PRC_FILIAL_GLB_FUSO_HORARIO
        ADD CONSTRAINT FK_PRC_FILIAL_GLB_FUSO_HORARIO_PRC_FILIAL FOREIGN KEY(CD_EMP,CD_FILIAL) REFERENCES PRC_FILIAL(CD_EMP,CD_FILIAL)
GO
ALTER TABLE PRC_FILIAL_GLB_FUSO_HORARIO
        ADD CONSTRAINT FK_PRC_FILIAL_GLB_FUSO_HORARIO_GLB_FUSO_HORARIO FOREIGN KEY(CD_FUSO_HORARIO) REFERENCES GLB_FUSO_HORARIO (CD_FUSO_HORARIO)

GO
CREATE FUNCTION GETDATE_FUSO_HORARIO(@CD_FILIAL INT)
RETURNS DATETIME AS
BEGIN
DECLARE @DIFERENCA_MINUTOS INT;
SELECT	@DIFERENCA_MINUTOS = FUSO_HORARIO.DIFER_MINUTOS
FROM	GLB_FUSO_HORARIO FUSO_HORARIO 
            INNER JOIN PRC_FILIAL_GLB_FUSO_HORARIO FUSO_HORARIO_FILIAL
            ON FUSO_HORARIO.CD_FUSO_HORARIO = FUSO_HORARIO_FILIAL.CD_FUSO_HORARIO
WHERE	FUSO_HORARIO_FILIAL.CD_FILIAL = @CD_FILIAL

RETURN DATEADD(MINUTE,COALESCE(@DIFERENCA_MINUTOS,0),GETDATE())
END
